package
{
	import com.pokkt.pokktsdk.PokktEvent;
	
	import starling.display.Button;
	import starling.events.Event;
	import starling.text.TextField;

	public class PlayVideoScreen extends BaseScreen
	{
		[Embed(source="assets/button1.png")]
		public static const BUTTON1:Class;
		
		[Embed(source="assets/button2.png")]
		public static const BUTTON2:Class;
		
		private var _btnStartCaching:Button;
		private var _btnPlayIncentVdo:Button;
		private var _btnPlayNonIncentVdo:Button;
		private var _btnWithUserIntent:Button;
		private var _txtEarnedPoint:TextField;
		private var _txtInfo:TextField;
		
		private var _yPadding:int = 15;
		
		private var _pokktManager:PokktManager;
		private var _totalEarnedPoint:int;
		
		private var _callback:Function;
		
		public function PlayVideoScreen(callback:Function)
		{
			super();
			
			_callback = callback;
			
			_imgLogo.y = _imgLogo.y/2;
			
			_txtEarnedPoint = GetUIComponent.getTextField("Points earned: 0", 20 * Constants.X_SCALE, false);
			_txtEarnedPoint.x = 10 * Constants.X_SCALE;
			_txtEarnedPoint.y = _imgLogo.y  +_imgLogo.height;
			addChild(_txtEarnedPoint);
			
			_txtInfo = GetUIComponent.getTextField("Getting Vdo Campaign. Button will get enable after caching Video.", 15 * Constants.X_SCALE, false);
			_txtInfo.x = 10 * Constants.X_SCALE;
			_txtInfo.y = _txtEarnedPoint.y  +_txtEarnedPoint.height + _yPadding/2 * Constants.Y_SCALE;
			addChild(_txtInfo);
			
			_btnStartCaching = GetUIComponent.getButton(BUTTON1, "Start Caching", 10);
			_btnStartCaching.y = _txtInfo.y + _txtInfo.height + _yPadding * Constants.Y_SCALE;
			_btnStartCaching.addEventListener(Event.TRIGGERED, onStartCachingClick);
			addChild(_btnStartCaching);
			
			_btnPlayIncentVdo = GetUIComponent.getButton(BUTTON1, "Play Incent Vdo To Earn", 10);
			_btnPlayIncentVdo.y = _btnStartCaching.y + _btnStartCaching.height + _yPadding * Constants.Y_SCALE;
			_btnPlayIncentVdo.addEventListener(Event.TRIGGERED, onPlayIncentVdoClick);
			addChild(_btnPlayIncentVdo);
			
			_btnPlayNonIncentVdo = GetUIComponent.getButton(BUTTON2, "Play Non-Incent Vdo", 10);
			_btnPlayNonIncentVdo.y = _btnPlayIncentVdo.y + _btnPlayIncentVdo.height + _yPadding * Constants.Y_SCALE;
			_btnPlayNonIncentVdo.addEventListener(Event.TRIGGERED, onPlayNonIncentVdoClick);
			addChild(_btnPlayNonIncentVdo);
			
			_btnWithUserIntent = GetUIComponent.getButton(BUTTON2, "With User Intent Vdo", 10);
			_btnWithUserIntent.y = _btnPlayNonIncentVdo.y + _btnPlayNonIncentVdo.height + _yPadding * Constants.Y_SCALE;
			_btnWithUserIntent.addEventListener(Event.TRIGGERED, onWithUserIntentClick);
			addChild(_btnWithUserIntent);
			
			//Pokkt
			_pokktManager = PokktManager.getInstance();
			_pokktManager.createExtension();
			_pokktManager.setDebug(true);
			
			if(!PokktManager.IsAutoCacheVideo)
			{
				_pokktManager.setParams("iJ02lJss0M", "a2717a45b835b5e9f50284a38d62a74e", "123456", "0", "false");
			}
			else
			{
				_btnStartCaching.visible = false;
			}
			
			// this call shoukld always be after set params
			_pokktManager.initPokkt();
			_pokktManager.setDefaultSkipTime(10);
			//set this params and pass false for auto cache.
			_pokktManager.addEventListener(PokktEvent.DOWNLOAD_COMPLETED_EVENTS, onDownloadCompleted);
			_pokktManager.addEventListener(PokktEvent.DOWNLOAD_FAILED_EVENTS, onDownloadFailed);
			_pokktManager.addEventListener(PokktEvent.VIDEO_CLOSED_EVENTS, onVideoClosed);
			_pokktManager.addEventListener(PokktEvent.VIDEO_COMPLETED_EVENTS, onVideoCompleted);
			_pokktManager.addEventListener(PokktEvent.VIDEO_SKIPPED_EVENTS, onVideoSkipped);
			_pokktManager.addEventListener(PokktEvent.VIDEO_DISPLAYED_EVENTS, onVideoDisplayed);
			_pokktManager.addEventListener(PokktEvent.VIDEO_GRATIFIED_EVENTS, onVideoGratified);
			
			disableButton();
		}
		
		private function disableButton():void
		{
			_btnPlayIncentVdo.enabled = false;
			_btnPlayNonIncentVdo.enabled = false;
			_btnStartCaching.enabled = true;
			//_btnWithUserIntent.enabled = false;
		}
		
		private function enableButton():void
		{
			_btnPlayIncentVdo.enabled = true;
			_btnPlayNonIncentVdo.enabled = true;
			_btnStartCaching.enabled = false;
			//_btnWithUserIntent.enabled = true;
		}
		
		//Callback functions
		protected function onVideoGratified(event:PokktEvent):void
		{
			trace("onVideoGratified");
			_totalEarnedPoint = _totalEarnedPoint + int(event.value);
			_txtEarnedPoint.text = "Points earned: "  + _totalEarnedPoint;
			disableButton();
		}
		
		protected function onVideoDisplayed(event:PokktEvent):void
		{
			trace("onVideoDisplayed");
			disableButton();
		}
		
		protected function onVideoSkipped(event:PokktEvent):void
		{
			trace("onVideoSkipped");
			disableButton();
		}
		
		protected function onVideoCompleted(event:PokktEvent):void
		{
			trace("onVideoCompleted");
			disableButton();
		}
		
		protected function onVideoClosed(event:PokktEvent):void
		{
			trace("onVideoClosed");
			disableButton();
		}
		
		protected function onDownloadCompleted(event:PokktEvent):void
		{
			trace("onDownloadCompleted");
			enableButton();
		}
		
		protected function onDownloadFailed(event:PokktEvent):void
		{
			trace("onDownloadFailed");
			disableButton();
		}
		
		//click listener
		protected function onStartCachingClick(event:Event):void
		{
			trace(event.currentTarget);
			//_pokktExtension.performOperation(PokktOperation.START_CACHING_VIDEO);
			_pokktManager.startCaching();
		}
		
		//Button click functions
		protected function onPlayIncentVdoClick(event:starling.events.Event):void
		{
			trace(event.currentTarget);
			_pokktManager.playVideoIncent("PokktAirSample");
		}
		
		protected function onPlayNonIncentVdoClick(event:starling.events.Event):void
		{
			trace(event.currentTarget);
			_pokktManager.playVideoNonIncent("PokktAirSample");
		}
		
		protected function onWithUserIntentClick(event:starling.events.Event):void
		{
			trace(event.currentTarget);
			if(_pokktManager.IsVideoAvailable())
				_pokktManager.playVideoWithoutIntent("PokktAirSample");
			else
				_callback.call(null, false);
		}
		
		override public function dispose():void
		{
			super.dispose();
			_pokktManager.removeEventListener(PokktEvent.DOWNLOAD_COMPLETED_EVENTS, onDownloadCompleted);
			_pokktManager.removeEventListener(PokktEvent.DOWNLOAD_FAILED_EVENTS, onDownloadFailed);
			_pokktManager.removeEventListener(PokktEvent.VIDEO_CLOSED_EVENTS, onVideoClosed);
			_pokktManager.removeEventListener(PokktEvent.VIDEO_COMPLETED_EVENTS, onVideoCompleted);
			_pokktManager.removeEventListener(PokktEvent.VIDEO_SKIPPED_EVENTS, onVideoSkipped);
			_pokktManager.removeEventListener(PokktEvent.VIDEO_DISPLAYED_EVENTS, onVideoDisplayed);
			_pokktManager.removeEventListener(PokktEvent.VIDEO_GRATIFIED_EVENTS, onVideoGratified);
		}
	}
}